﻿/// <reference name="MicrosoftAjax.js"/>

Type.registerNamespace("ImageRotatorExtender");

ImageRotatorExtender.ImageRotator = function(element) {
    ImageRotatorExtender.ImageRotator.initializeBase(this, [element]);
    this._imageIndex = 0;
    this._imageList = null;
    this._rotationInterval = 3;
    this._intervalId;
}

ImageRotatorExtender.ImageRotator.prototype = {
    initialize: function() {
        Sys.Debug.trace("initialization");
        this._setupRotation();
        ImageRotatorExtender.ImageRotator.callBaseMethod(this, 'initialize');
    },
    dispose: function() {        
        Sys.Debug.trace("disposing");
        this._imageList = null;
        
        // aby wymusić dziwne zachowanie, umieść poniższe wywołanie w komentarzu
        window.clearInterval(this._intervalId);
        
        ImageRotatorExtender.ImageRotator.callBaseMethod(this, 'dispose');
    },
    get_rotationInterval: function(){
        return this._rotationInterval;
    },
    set_rotationInterval: function(value){
        this._rotationInterval = value;
    },
    get_imageList: function(){
        return this._imageList;
    },
    set_imageList: function(value){
        this._imageList = value;
    },
    _setupRotation: function(){
        var expression = String.format("$get('{0}').ImageRotator._rotateImage()",this.get_element().id);
        this._intervalId = window.setInterval(expression,this.get_rotationInterval()*1000);
    },
    _rotateImage: function(){
        var element = this.get_element();
        if(element)
        {
            element.src = this._imageList[this._imageIndex++];
            if(this._imageIndex > this._imageList.length - 1)
                this._imageIndex = 0;
        }
    }
}
ImageRotatorExtender.ImageRotator.registerClass(
    'ImageRotatorExtender.ImageRotator', Sys.UI.Behavior);

if (typeof(Sys) !== 'undefined') Sys.Application.notifyScriptLoaded();